/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier;

import com.c2h6s.etshtinker.Modifiers.modifiers.EtSTBaseModifier;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class SelfRegulate
extends EtSTBaseModifier
implements RawDataModifierHook {
    public static final String KEY_LAST_DURABILITY = "self_regulate_durability";
    public static final String KEY_BONUS = "self_regulate_bonus";

    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, ModifierHooks.RAW_DATA);
    }

    public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
        if (tag.getInt(KEY_LAST_DURABILITY) <= 0) {
            tag.putInt(KEY_LAST_DURABILITY, tool.getStats().getInt((IToolStat)ToolStats.DURABILITY));
        } else {
            int last_durability = tag.getInt(KEY_LAST_DURABILITY);
            int durability = tool.getStats().getInt((IToolStat)ToolStats.DURABILITY);
            if (durability > last_durability) {
                float bonus = tag.getFloat(KEY_BONUS);
                tag.putFloat(KEY_BONUS, (float)((double)bonus + (double)modifier.getLevel() * Math.log10(durability - last_durability) / Math.log10(1.2)));
                tag.putFloat(KEY_LAST_DURABILITY, (float)durability);
            }
        }
    }

    public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
        tag.remove(KEY_LAST_DURABILITY);
        tag.remove(KEY_BONUS);
    }

    public float onGetMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        ToolStack toolStack = (ToolStack)tool;
        if (toolStack.getRestrictedNBT().getFloat(KEY_BONUS) > 0.0f) {
            damage += toolStack.getRestrictedNBT().getFloat(KEY_BONUS);
        }
        return damage;
    }

    public void modifierOnProjectileLaunch(IToolStackView tool, ModifierEntry modifiers, LivingEntity livingEntity, Projectile projectile, @Nullable AbstractArrow abstractArrow, NamespacedNBT namespacedNBT, boolean primary) {
        ToolStack toolStack = (ToolStack)tool;
        if (toolStack.getRestrictedNBT().getFloat(KEY_BONUS) > 0.0f && abstractArrow != null) {
            abstractArrow.m_36781_(abstractArrow.m_36789_() + (double)toolStack.getRestrictedNBT().getFloat(KEY_BONUS));
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ToolStack toolStack = (ToolStack)tool;
        if (toolStack.getRestrictedNBT().getFloat(KEY_BONUS) > 0.0f) {
            tooltip.add((Component)Component.m_237115_((String)"cti.tooltip.modifier.self_regulate").m_130946_(String.format("%.2f", Float.valueOf(toolStack.getRestrictedNBT().getFloat(KEY_BONUS)))).m_130948_(this.getDisplayName().m_7383_()));
        }
    }
}

